/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder;

import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.event.ClientResourceReloadListener;
import net.createmod.catnip.ghostblock.GhostBlocks;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.levelWrappers.WrappedClientLevel;
import net.createmod.catnip.net.ClientboundSimpleActionPacket;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.createmod.ponder.command.SimplePonderActions;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.content.BasePonderPlugin;
import net.createmod.ponder.foundation.content.DebugPonderPlugin;
import net.createmod.ponder.foundation.element.WorldSectionElementImpl;
import net.minecraft.class_1936;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class PonderClient {
    public static final ClientResourceReloadListener RESOURCE_RELOAD_LISTENER = new ClientResourceReloadListener();
    public static final GhostBlocks GHOST_BLOCKS = GhostBlocks.getInstance();

    public static void init() {
        SuperByteBufferCache.getInstance().registerCompartment(CachedBuffers.GENERIC_BLOCK);
        SuperByteBufferCache.getInstance().registerCompartment(WorldSectionElementImpl.PONDER_WORLD_SECTION);
        UIRenderHelper.init();
        ClientboundSimpleActionPacket.addAction("openPonder", () -> SimplePonderActions::openPonder);
        ClientboundSimpleActionPacket.addAction("reloadPonder", () -> SimplePonderActions::reloadPonder);
        PonderIndex.addPlugin(new BasePonderPlugin());
        if (CatnipServices.PLATFORM.isDevelopmentEnvironment()) {
            PonderIndex.addPlugin(new DebugPonderPlugin());
        }
    }

    public static void modLoadCompleted() {
        PonderIndex.registerAll();
    }

    public static void onTick() {
        AnimationTickHolder.tick();
        if (!PonderClient.isGameActive()) {
            return;
        }
        PlacementClient.tick();
        GhostBlocks.getInstance().tickGhosts();
        Outliner.getInstance().tickOutlines();
    }

    public static void onRenderWorld(class_4587 ms) {
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        ms.method_22903();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        GHOST_BLOCKS.renderAll(ms, buffer, cameraPos);
        Outliner.getInstance().renderOutlines(ms, buffer, cameraPos, partialTicks);
        buffer.draw();
        ms.method_22909();
    }

    public static void invalidateRenderers() {
        SuperByteBufferCache.getInstance().invalidate();
    }

    public static void onLoadWorld(class_1936 level) {
        if (!level.method_8608()) {
            return;
        }
        if (level instanceof class_638 && !(level instanceof WrappedClientLevel)) {
            PonderClient.invalidateRenderers();
            AnimationTickHolder.reset();
        }
    }

    public static void onUnloadWorld(class_1936 level) {
        if (!level.method_8608()) {
            return;
        }
        PonderClient.invalidateRenderers();
        AnimationTickHolder.reset();
    }

    public static boolean isGameActive() {
        return class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null;
    }
}

